<?php
/**
 * Collection Intro
 *
 * @package snax 1.19
 * @subpackage Collections
 */
?>
<div class="snax-collection-intro">
	<p class="g1-gamma g1-gamma-3rd"><?php esc_html_e( 'Please log in to use the History and find posts you recently saw.', 'snax' ); ?></p>

	<h2><?php esc_html_e( 'How Does It Work?', 'snax' ); ?></h2>

	<div class="snax-collection-intro-columns">
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-history-1"></div>
			<h3><?php esc_html_e( 'Log In', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'The History is only available to logged in users, so please log in or register now.', 'snax' ); ?>
			</p>
		</div>
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-history-2"></div>
			<h3><?php esc_html_e( 'Browse Posts', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Every visited post will be tracked now.', 'snax' ); ?>
				<?php esc_html_e( 'You can delete individual items or clear your entire history.', 'snax' ); ?>
			</p>
		</div>
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-history-3"></div>
			<h3><?php esc_html_e( 'Check Your History', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Easily find recently viewed posts.', 'snax' ); ?>
				<?php esc_html_e( 'Other users won\'t have access to your History though.', 'snax' ); ?>
			</p>
		</div>
	</div>
</div>
