<?php
/**
 * Collection Intro
 *
 * @package snax 1.19
 * @subpackage Collections
 */
?>
<div class="snax-collection-intro">
	<p class="g1-gamma g1-gamma-3rd"><?php esc_html_e( 'Please log in to use Custom Collections and organize posts into collections.', 'snax' ); ?></p>

	<h2><?php esc_html_e( 'How Does It Work?', 'snax' ); ?></h2>

	<div class="snax-collection-intro-columns">
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-custom-1"></div>
			<h3><?php esc_html_e( 'Log In', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Custom Collections are only available to logged in users, so please log in or register now.', 'snax' ); ?>
			</p>
		</div>
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-custom-2"></div>
			<h3><?php esc_html_e( 'Add Posts to Collections', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Pick up posts you like and add them to various collections, you\'ve created before.', 'snax' ); ?>
				<?php esc_html_e( 'You can delete individual items, clear and delete entire collections.', 'snax' ); ?>
			</p>
		</div>
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-custom-3"></div>
			<h3><?php esc_html_e( 'Browse Your Collections', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Easily find posts you\'ve previously organized into collections.', 'snax' ); ?>
				<?php esc_html_e( 'Other users won\'t have access to your Custom Collections though, unless you make them Public.', 'snax' ); ?>
			</p>
		</div>
	</div>
</div>


